/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.filechooser.FileFilter;
import xeij.ComponentFactory;
import xeij.HDC;
import xeij.HFS;
import xeij.JFileChooser2;
import xeij.Keyboard;
import xeij.MainMemory;
import xeij.MemoryMappedDevice;
import xeij.Multilingual;
import xeij.ROM;
import xeij.SPC;
import xeij.Settings;
import xeij.XEiJ;

public class SRAM {
    public static int smrSramSizeRequest;
    public static int smrSramCurrentSize;
    public static String smrSramName;
    public static int smrBootDevice;
    public static int smrROMBootHandle;
    public static int smrRAMBootAddress;
    public static int smrRepeatDelay;
    public static int smrRepeatInterval;
    public static boolean smrWriteEnableOn;
    public static int smrRomdbFlag;
    public static boolean smrModifyMemorySizeOn;
    public static boolean smrSRAMBusErrorOn;
    public static JMenu smrRepeatDelayMenu;
    public static JMenu smrRepeatIntervalMenu;
    public static JMenu smrRomdbMenu;
    public static JMenuItem smrModifyMemorySizeMenuItem;
    public static JMenu smrMenu;
    public static JMenu smrBootMenu;
    public static JRadioButtonMenuItem smrSTDMenuItem;

    public static void smrInit() {
        int n;
        byte[] byArray;
        int n2 = Settings.sgsGetInt("sramsize");
        smrSramCurrentSize = smrSramSizeRequest = n2 == 16 || n2 == 32 || n2 == 64 ? n2 << 10 : 16384;
        System.out.printf(Multilingual.mlnJapanese ? "SRAM \u306e\u30b5\u30a4\u30ba\u306f %dKB \u3067\u3059\n" : "SRAM size is %dKB\n", smrSramSizeRequest >> 10);
        boolean bl = false;
        smrSramName = "";
        if (!bl && (smrSramName = Settings.sgsGetString("sram")).length() != 0 && (byArray = XEiJ.rscGetFile(smrSramName, smrSramSizeRequest)) != null) {
            System.arraycopy(byArray, 0, MainMemory.mmrM8, 0xED0000, smrSramSizeRequest);
            if (smrSramSizeRequest < 65536) {
                Arrays.fill(MainMemory.mmrM8, 0xED0000 + smrSramSizeRequest, 0xEE0000, (byte)0);
            }
            bl = true;
        }
        if (!bl && (byArray = Settings.sgsGetData("sramdata")).length != 0) {
            System.out.println(Multilingual.mlnJapanese ? "SRAM \u306e\u30c7\u30fc\u30bf\u3092\u5fa9\u5143\u3057\u307e\u3059" : "SRAM data is restored");
            System.arraycopy(byArray, 0, MainMemory.mmrM8, 0xED0000, Math.min(byArray.length, smrSramSizeRequest));
            if (byArray.length < smrSramSizeRequest) {
                Arrays.fill(MainMemory.mmrM8, 0xED0000 + byArray.length, 0xED0000 + smrSramSizeRequest, (byte)0);
            }
            if (smrSramSizeRequest < 65536) {
                Arrays.fill(MainMemory.mmrM8, 0xED0000 + smrSramSizeRequest, 0xEE0000, (byte)0);
            }
            bl = true;
        }
        if (!bl) {
            System.out.println(Multilingual.mlnJapanese ? "SRAM \u3092\u30bc\u30ed\u30af\u30ea\u30a2\u3057\u307e\u3059" : "SRAM is zero-cleared");
            Arrays.fill(MainMemory.mmrM8, 0xED0000, 0xEE0000, (byte)0);
            bl = true;
        }
        smrRepeatDelay = -1 <= (n = Settings.sgsGetInt("keydly")) && n <= 15 ? n : -1;
        int n3 = Settings.sgsGetInt("keyrep");
        smrRepeatInterval = -1 <= n3 && n3 <= 15 ? n3 : -1;
        String string = Settings.sgsGetString("romdb").toLowerCase();
        smrRomdbFlag = string.equals("off") ? 0 : (string.equals("on") || string.equals("aux") ? 255 : (string.equals("con") ? 1 : -1));
        smrModifyMemorySizeOn = Settings.sgsGetOnOff("modifymemorysize");
        smrSRAMBusErrorOn = Settings.sgsGetOnOff("srambuserror");
        SRAM.smrParseBootDevice(Settings.sgsGetString("boot"));
    }

    public static void smrTini() {
        Settings.sgsPutInt("sramsize", smrSramSizeRequest >> 10);
        Settings.sgsPutString("sram", smrSramName);
        Settings.sgsPutData("sramdata", MainMemory.mmrM8, 0xED0000, 65536);
        Settings.sgsPutInt("keydly", smrRepeatDelay);
        Settings.sgsPutInt("keyrep", smrRepeatInterval);
        Settings.sgsPutString("romdb", smrRomdbFlag == 0 ? "off" : (smrRomdbFlag == 255 ? "aux" : (smrRomdbFlag == 1 ? "con" : "")));
        Settings.sgsPutOnOff("modifymemorysize", smrModifyMemorySizeOn);
        Settings.sgsPutOnOff("srambuserror", smrSRAMBusErrorOn);
        Settings.sgsPutString("boot", (String)(smrBootDevice == -1 ? "default" : (smrBootDevice == 0 ? "std" : ((smrBootDevice & 0xF000) == 36864 ? "fd" + (smrBootDevice >> 8 & 3) : ((smrBootDevice & 0xF000) == 32768 ? "hd" + (smrBootDevice >> 8 & 0xF) : (smrBootDevice == 40960 ? ((smrROMBootHandle & 0xFFFFFFE3) == 15335456 ? "sc" + (smrROMBootHandle >> 2 & 7) : ((smrROMBootHandle & 0xFFFFFFE3) == 0xFC0000 ? "sc" + (smrROMBootHandle >> 2 & 7) : (smrROMBootHandle == 15331360 ? "hf" + HFS.hfsBootUnit : String.format("rom$%08X", smrROMBootHandle)))) : (smrBootDevice == 45056 ? String.format("ram$%08X", smrRAMBootAddress) : "")))))));
    }

    public static void smrMakeMenu() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                Object object = actionEvent.getSource();
                switch (string = actionEvent.getActionCommand()) {
                    case "Modify the memory size in SRAM": {
                        smrModifyMemorySizeOn = ((JCheckBoxMenuItem)object).isSelected();
                        break;
                    }
                    case "Zero-clear": {
                        SRAM.smrClear();
                        break;
                    }
                    case "Import": {
                        SRAM.smrLoad();
                        break;
                    }
                    case "Export": {
                        SRAM.smrSave();
                        break;
                    }
                    case "16KB": {
                        smrSramSizeRequest = 16384;
                        break;
                    }
                    case "32KB": {
                        smrSramSizeRequest = 32768;
                        break;
                    }
                    case "64KB": {
                        smrSramSizeRequest = 65536;
                        break;
                    }
                    case "Bus error when writing to SRAM": {
                        smrSRAMBusErrorOn = ((JCheckBoxMenuItem)object).isSelected();
                        break;
                    }
                    default: {
                        System.out.println("unknown action command " + string);
                    }
                }
            }
        };
        ActionListener actionListener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                switch (string = actionEvent.getActionCommand()) {
                    case "Follow settings in SWITCH.X": {
                        smrRepeatDelay = -1;
                        Keyboard.kbdSetRepeatDelay(MainMemory.mmrRbs(15532090));
                        break;
                    }
                    case "200ms": 
                    case "300ms": 
                    case "400ms": 
                    case "500ms": 
                    case "600ms": 
                    case "700ms": 
                    case "800ms": 
                    case "900ms": 
                    case "1000ms": 
                    case "1100ms": 
                    case "1200ms": 
                    case "1300ms": 
                    case "1400ms": 
                    case "1500ms": 
                    case "1600ms": 
                    case "1700ms": {
                        int n = Integer.parseInt(string.substring(0, string.length() - 2));
                        smrRepeatDelay = (n - 200) * 1311 >>> 17;
                        Keyboard.kbdSetRepeatDelay(smrRepeatDelay);
                        MainMemory.mmrWb(15532090, smrRepeatDelay);
                        break;
                    }
                    default: {
                        System.out.println("unknown action command " + string);
                    }
                }
            }
        };
        ButtonGroup buttonGroup = new ButtonGroup();
        smrRepeatDelayMenu = Multilingual.mlnText(ComponentFactory.createMenu("Repeat delay", Multilingual.mlnText(ComponentFactory.createRadioButtonMenuItem(buttonGroup, smrRepeatDelay == -1, "Follow settings in SWITCH.X", actionListener2), "ja", "SWITCH.X \u306e\u8a2d\u5b9a\u306b\u5f93\u3046"), ComponentFactory.createRadioButtonMenuItem(buttonGroup, smrRepeatDelay == 0, "200ms", actionListener2), ComponentFactory.createRadioButtonMenuItem(buttonGroup, smrRepeatDelay == 1, "300ms", actionListener2), ComponentFactory.createRadioButtonMenuItem(buttonGroup, smrRepeatDelay == 2, "400ms", actionListener2), ComponentFactory.createRadioButtonMenuItem(buttonGroup, smrRepeatDelay == 3, "500ms", actionListener2), ComponentFactory.createRadioButtonMenuItem(buttonGroup, smrRepeatDelay == 4, "600ms", actionListener2), ComponentFactory.createRadioButtonMenuItem(buttonGroup, smrRepeatDelay == 5, "700ms", actionListener2), ComponentFactory.createRadioButtonMenuItem(buttonGroup, smrRepeatDelay == 6, "800ms", actionListener2), ComponentFactory.createRadioButtonMenuItem(buttonGroup, smrRepeatDelay == 7, "900ms", actionListener2), ComponentFactory.createRadioButtonMenuItem(buttonGroup, smrRepeatDelay == 8, "1000ms", actionListener2), ComponentFactory.createRadioButtonMenuItem(buttonGroup, smrRepeatDelay == 9, "1100ms", actionListener2), ComponentFactory.createRadioButtonMenuItem(buttonGroup, smrRepeatDelay == 10, "1200ms", actionListener2), ComponentFactory.createRadioButtonMenuItem(buttonGroup, smrRepeatDelay == 11, "1300ms", actionListener2), ComponentFactory.createRadioButtonMenuItem(buttonGroup, smrRepeatDelay == 12, "1400ms", actionListener2), ComponentFactory.createRadioButtonMenuItem(buttonGroup, smrRepeatDelay == 13, "1500ms", actionListener2), ComponentFactory.createRadioButtonMenuItem(buttonGroup, smrRepeatDelay == 14, "1600ms", actionListener2), ComponentFactory.createRadioButtonMenuItem(buttonGroup, smrRepeatDelay == 15, "1700ms", actionListener2)), "ja", "\u30ea\u30d4\u30fc\u30c8\u958b\u59cb");
        ActionListener actionListener3 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                switch (string = actionEvent.getActionCommand()) {
                    case "Follow settings in SWITCH.X": {
                        smrRepeatInterval = -1;
                        Keyboard.kbdSetRepeatInterval(MainMemory.mmrRbs(15532091));
                        break;
                    }
                    case "30ms": 
                    case "35ms": 
                    case "50ms": 
                    case "75ms": 
                    case "110ms": 
                    case "155ms": 
                    case "210ms": 
                    case "275ms": 
                    case "350ms": 
                    case "435ms": 
                    case "530ms": 
                    case "635ms": 
                    case "750ms": 
                    case "875ms": 
                    case "1010ms": 
                    case "1155ms": {
                        int n = Integer.parseInt(string.substring(0, string.length() - 2));
                        smrRepeatInterval = (int)Math.sqrt((n - 30) * 1639 >>> 13);
                        Keyboard.kbdSetRepeatInterval(smrRepeatInterval);
                        MainMemory.mmrWb(15532091, smrRepeatInterval);
                        break;
                    }
                    default: {
                        System.out.println("unknown action command " + string);
                    }
                }
            }
        };
        ButtonGroup buttonGroup2 = new ButtonGroup();
        smrRepeatIntervalMenu = Multilingual.mlnText(ComponentFactory.createMenu("Repeat interval", Multilingual.mlnText(ComponentFactory.createRadioButtonMenuItem(buttonGroup2, smrRepeatInterval == -1, "Follow settings in SWITCH.X", actionListener3), "ja", "SWITCH.X \u306e\u8a2d\u5b9a\u306b\u5f93\u3046"), ComponentFactory.createRadioButtonMenuItem(buttonGroup2, smrRepeatInterval == 0, "30ms", actionListener3), ComponentFactory.createRadioButtonMenuItem(buttonGroup2, smrRepeatInterval == 1, "35ms", actionListener3), ComponentFactory.createRadioButtonMenuItem(buttonGroup2, smrRepeatInterval == 2, "50ms", actionListener3), ComponentFactory.createRadioButtonMenuItem(buttonGroup2, smrRepeatInterval == 3, "75ms", actionListener3), ComponentFactory.createRadioButtonMenuItem(buttonGroup2, smrRepeatInterval == 4, "110ms", actionListener3), ComponentFactory.createRadioButtonMenuItem(buttonGroup2, smrRepeatInterval == 5, "155ms", actionListener3), ComponentFactory.createRadioButtonMenuItem(buttonGroup2, smrRepeatInterval == 6, "210ms", actionListener3), ComponentFactory.createRadioButtonMenuItem(buttonGroup2, smrRepeatInterval == 7, "275ms", actionListener3), ComponentFactory.createRadioButtonMenuItem(buttonGroup2, smrRepeatInterval == 8, "350ms", actionListener3), ComponentFactory.createRadioButtonMenuItem(buttonGroup2, smrRepeatInterval == 9, "435ms", actionListener3), ComponentFactory.createRadioButtonMenuItem(buttonGroup2, smrRepeatInterval == 10, "530ms", actionListener3), ComponentFactory.createRadioButtonMenuItem(buttonGroup2, smrRepeatInterval == 11, "635ms", actionListener3), ComponentFactory.createRadioButtonMenuItem(buttonGroup2, smrRepeatInterval == 12, "750ms", actionListener3), ComponentFactory.createRadioButtonMenuItem(buttonGroup2, smrRepeatInterval == 13, "875ms", actionListener3), ComponentFactory.createRadioButtonMenuItem(buttonGroup2, smrRepeatInterval == 14, "1010ms", actionListener3), ComponentFactory.createRadioButtonMenuItem(buttonGroup2, smrRepeatInterval == 15, "1155ms", actionListener3)), "ja", "\u30ea\u30d4\u30fc\u30c8\u9593\u9694");
        ActionListener actionListener4 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                switch (string = actionEvent.getActionCommand()) {
                    case "Follow settings in SWITCH.X": {
                        smrRomdbFlag = -1;
                        break;
                    }
                    case "OFF": {
                        smrRomdbFlag = 0;
                        break;
                    }
                    case "AUX": {
                        smrRomdbFlag = 255;
                        break;
                    }
                    case "CON (when using IPLROM 1.6)": {
                        smrRomdbFlag = 1;
                        break;
                    }
                    default: {
                        System.out.println("unknown action command " + string);
                    }
                }
            }
        };
        ButtonGroup buttonGroup3 = new ButtonGroup();
        smrRomdbMenu = Multilingual.mlnText(ComponentFactory.createMenu("ROM debugger start flag", Multilingual.mlnText(ComponentFactory.createRadioButtonMenuItem(buttonGroup3, smrRomdbFlag == -1, "Follow settings in SWITCH.X", actionListener4), "ja", "SWITCH.X \u306e\u8a2d\u5b9a\u306b\u5f93\u3046"), ComponentFactory.createRadioButtonMenuItem(buttonGroup3, smrRomdbFlag == 0, "OFF", actionListener4), ComponentFactory.createRadioButtonMenuItem(buttonGroup3, smrRomdbFlag == 255, "AUX", actionListener4), Multilingual.mlnText(ComponentFactory.createRadioButtonMenuItem(buttonGroup3, smrRomdbFlag == 1, "CON (when using IPLROM 1.6)", actionListener4), "ja", "CON (IPLROM 1.6 \u4f7f\u7528\u6642)")), "ja", "ROM \u30c7\u30d0\u30c3\u30ac\u8d77\u52d5\u30d5\u30e9\u30b0");
        smrModifyMemorySizeMenuItem = Multilingual.mlnText(ComponentFactory.createCheckBoxMenuItem(smrModifyMemorySizeOn, "Modify the memory size in SRAM", actionListener), "ja", "SRAM \u306b\u3042\u308b\u30e1\u30e2\u30ea\u30b5\u30a4\u30ba\u3092\u4fee\u6b63\u3059\u308b");
        ButtonGroup buttonGroup4 = new ButtonGroup();
        smrMenu = ComponentFactory.createMenu("SRAM", Multilingual.mlnText(ComponentFactory.createMenuItem("Zero-clear", actionListener), "ja", "\u30bc\u30ed\u30af\u30ea\u30a2"), Multilingual.mlnText(ComponentFactory.createMenuItem("Import", actionListener), "ja", "\u30a4\u30f3\u30dd\u30fc\u30c8"), Multilingual.mlnText(ComponentFactory.createMenuItem("Export", actionListener), "ja", "\u30a8\u30af\u30b9\u30dd\u30fc\u30c8"), ComponentFactory.createHorizontalSeparator(), Multilingual.mlnText(ComponentFactory.createRadioButtonMenuItem(buttonGroup4, smrSramSizeRequest >> 10 == 16, "16KB", actionListener), "ja", "16KB"), Multilingual.mlnText(ComponentFactory.createRadioButtonMenuItem(buttonGroup4, smrSramSizeRequest >> 10 == 32, "32KB", actionListener), "ja", "32KB"), Multilingual.mlnText(ComponentFactory.createRadioButtonMenuItem(buttonGroup4, smrSramSizeRequest >> 10 == 64, "64KB", actionListener), "ja", "64KB"), ComponentFactory.createHorizontalSeparator(), Multilingual.mlnText(ComponentFactory.createCheckBoxMenuItem(smrSRAMBusErrorOn, "Bus error when writing to SRAM", actionListener), "ja", "SRAM \u3078\u306e\u66f8\u304d\u8fbc\u307f\u6642\u306e\u30d0\u30b9\u30a8\u30e9\u30fc"));
        ButtonGroup buttonGroup5 = new ButtonGroup();
        ActionListener actionListener5 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                SRAM.smrParseBootDevice((String)(string.startsWith("FDD ") ? "fd" + string.substring(4) : (string.startsWith("SASI ") ? "hd" + string.substring(5) : (string.startsWith("SCSI ") ? "sc" + string.substring(5) : (string.startsWith("HFS ") ? "hf" + string.substring(4) : (string.equals("STD") ? "std" : "default"))))));
                if (smrBootDevice != -1) {
                    XEiJ.mpuSavedBootDevice = -1;
                    XEiJ.mpuSavedROMBootHandle = -1;
                }
            }
        };
        JMenu jMenu = ComponentFactory.createMenu("FDD", new JComponent[0]);
        for (int i = 0; i < 4; ++i) {
            jMenu.add(ComponentFactory.createRadioButtonMenuItem(buttonGroup5, smrBootDevice == 36976 + (i << 8), "FDD " + i, actionListener5));
        }
        JMenu jMenu2 = ComponentFactory.createMenu("SASI", new JComponent[0]);
        for (int i = 0; i < 16; ++i) {
            jMenu2.add(ComponentFactory.createRadioButtonMenuItem(buttonGroup5, smrBootDevice == 32768 + (i << 8), "SASI " + i, actionListener5));
        }
        JMenu jMenu3 = ComponentFactory.createMenu("SCSI", new JComponent[0]);
        for (int i = 0; i < 8; ++i) {
            jMenu3.add(ComponentFactory.createRadioButtonMenuItem(buttonGroup5, smrBootDevice == 40960 && (smrROMBootHandle == 15335456 + (i << 2) || smrROMBootHandle == 0xFC0000 + (i << 2)), "SCSI " + i, actionListener5));
        }
        JMenu jMenu4 = ComponentFactory.createMenu("HFS", new JComponent[0]);
        for (int i = 0; i < 16; ++i) {
            jMenu4.add(ComponentFactory.createRadioButtonMenuItem(buttonGroup5, smrBootDevice == 40960 && smrROMBootHandle == 15331360 && HFS.hfsBootUnit == i, "HFS " + i, actionListener5));
        }
        JComponent[] jComponentArray = new JComponent[6];
        jComponentArray[0] = Multilingual.mlnText(ComponentFactory.createRadioButtonMenuItem(buttonGroup5, smrBootDevice == -1, "Follow settings in SWITCH.X", actionListener5), "ja", "SWITCH.X \u306e\u8a2d\u5b9a\u306b\u5f93\u3046");
        smrSTDMenuItem = ComponentFactory.createRadioButtonMenuItem(buttonGroup5, smrBootDevice == 0, "STD", actionListener5);
        jComponentArray[1] = smrSTDMenuItem;
        jComponentArray[2] = jMenu;
        jComponentArray[3] = jMenu2;
        jComponentArray[4] = jMenu3;
        jComponentArray[5] = jMenu4;
        smrBootMenu = Multilingual.mlnText(ComponentFactory.createMenu("Boot device", jComponentArray), "ja", "\u8d77\u52d5\u30c7\u30d0\u30a4\u30b9");
    }

    public static void smrParseBootDevice(String string) {
        int n;
        smrBootDevice = -1;
        smrROMBootHandle = -1;
        smrRAMBootAddress = -1;
        if ((string = string.toLowerCase()).equals("std")) {
            smrBootDevice = 0;
        } else if (string.startsWith("fd")) {
            int n2 = XEiJ.fmtParseInt(string, 2, 0, 3, 4);
            if (n2 < 4) {
                smrBootDevice = 36976 + (n2 << 8);
            }
        } else if (string.startsWith("hd")) {
            int n3 = XEiJ.fmtParseInt(string, 2, 0, 15, 16);
            if (n3 < 16) {
                smrBootDevice = 32768 + (n3 << 8);
            }
        } else if (string.startsWith("sc")) {
            int n4 = XEiJ.fmtParseInt(string, 2, 0, 7, 8);
            if (n4 < 8) {
                smrBootDevice = 40960;
                smrROMBootHandle = 15335456 + ((n4 & 7) << 2);
            }
        } else if (string.startsWith("hf")) {
            int n5 = XEiJ.fmtParseInt(string, 2, 0, 15, 16);
            if (n5 < 16) {
                HFS.hfsBootUnit = n5;
                smrBootDevice = 40960;
                smrROMBootHandle = 15331360;
            }
        } else if (string.startsWith("rom$")) {
            int n6 = XEiJ.fmtParseIntRadix(string, 3, 0, 0xFFFFFF, 0x1000000, 16);
            if (n6 < 0x1000000) {
                smrBootDevice = 40960;
                smrROMBootHandle = n6;
            }
        } else if (string.startsWith("ram$") && (n = XEiJ.fmtParseIntRadix(string, 3, 0, 0xFFFFFF, 0x1000000, 16)) < 0x1000000) {
            smrBootDevice = 45056;
            smrRAMBootAddress = n;
        }
    }

    public static void smrReset() {
        smrWriteEnableOn = false;
        smrSramCurrentSize = smrSramSizeRequest;
        XEiJ.busSuper(MemoryMappedDevice.MMD_SMR, 0xED0000, 0xED0000 + smrSramSizeRequest);
        if (smrSramSizeRequest < 65536) {
            XEiJ.busSuper(MemoryMappedDevice.MMD_NUL, 0xED0000 + smrSramSizeRequest, 0xEE0000);
        }
        System.out.printf(Multilingual.mlnJapanese ? "SRAM \u306e\u5bb9\u91cf\u306f %dKB ($%08X-$%08X) \u3067\u3059\n" : "Capacity of SRAM is %dKB ($%08X-$%08X)\n", smrSramCurrentSize >> 10, 0xED0000, 0xED0000 + smrSramCurrentSize - 1);
        if ((smrROMBootHandle & 0xFFFFFFE3) == 0xFC0000 && !SPC.spcSCSIINOn) {
            if (SPC.spcSCSIEXOn) {
                smrROMBootHandle = 15335456 + (smrROMBootHandle & 0x1C);
            } else {
                smrROMBootHandle = 15205376;
                if (smrBootDevice == 40960) {
                    smrBootDevice = 0;
                    smrSTDMenuItem.setSelected(true);
                }
            }
        }
        if ((smrROMBootHandle & 0xFFFFFFE3) == 15335456 && !SPC.spcSCSIEXOn) {
            if (SPC.spcSCSIINOn) {
                smrROMBootHandle = 0xFC0000 + (smrROMBootHandle & 0x1C);
            } else {
                smrROMBootHandle = 15205376;
                if (smrBootDevice == 40960) {
                    smrBootDevice = 0;
                    smrSTDMenuItem.setSelected(true);
                }
            }
        }
        if (!(smrROMBootHandle != 15331360 || HFS.hfsUnitArray[HFS.hfsBootUnit].abuConnected && HFS.hfsUnitArray[HFS.hfsBootUnit].abuInserted)) {
            smrROMBootHandle = 15205376;
            if (smrBootDevice == 40960) {
                smrBootDevice = 0;
                smrSTDMenuItem.setSelected(true);
            }
        }
        if ((XEiJ.mpuROMBootHandle & 0xFFFFFFE3) == 0xFC0000 && !SPC.spcSCSIINOn) {
            if (SPC.spcSCSIEXOn) {
                XEiJ.mpuROMBootHandle = 15335456 + (XEiJ.mpuROMBootHandle & 0x1C);
            } else {
                XEiJ.mpuROMBootHandle = 15205376;
                if (XEiJ.mpuBootDevice == 40960) {
                    XEiJ.mpuBootDevice = 0;
                }
            }
        }
        if ((XEiJ.mpuROMBootHandle & 0xFFFFFFE3) == 15335456 && !SPC.spcSCSIEXOn) {
            if (SPC.spcSCSIINOn) {
                XEiJ.mpuROMBootHandle = 0xFC0000 + (XEiJ.mpuROMBootHandle & 0x1C);
            } else {
                XEiJ.mpuROMBootHandle = 15205376;
                if (XEiJ.mpuBootDevice == 40960) {
                    XEiJ.mpuBootDevice = 0;
                }
            }
        }
        if (!(XEiJ.mpuROMBootHandle != 15331360 || HFS.hfsUnitArray[HFS.hfsBootUnit].abuConnected && HFS.hfsUnitArray[HFS.hfsBootUnit].abuInserted)) {
            XEiJ.mpuROMBootHandle = 15205376;
            if (XEiJ.mpuBootDevice == 40960) {
                XEiJ.mpuBootDevice = 0;
            }
        }
        SRAM.smrOverride();
    }

    public static void smrOverride() {
        if (MainMemory.mmrRls(0xED0000) == -2106116552 && MainMemory.mmrRls(15532036) == 808464471) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            if (smrModifyMemorySizeOn && (n8 = MainMemory.mmrRls(n7 = 15532040)) != (n6 = MainMemory.mmrMemorySizeCurrent)) {
                MainMemory.mmrWl(n7, n6);
                System.out.printf(Multilingual.mlnJapanese ? "SRAM \u306b\u3042\u308b\u30e1\u30e2\u30ea\u30b5\u30a4\u30ba\u3092 %dMB \u304b\u3089 %dMB \u306b\u5909\u66f4\u3057\u307e\u3057\u305f\n" : "Changed the memory size in SRAM from %dMB to %dMB\n", n8 >> 20, n6 >> 20);
            }
            n7 = 15532044;
            n8 = MainMemory.mmrRls(n7);
            int n9 = n6 = XEiJ.mpuROMBootHandle != -1 ? XEiJ.mpuROMBootHandle : smrROMBootHandle;
            if (n6 != -1 && n8 != n6) {
                MainMemory.mmrWl(n7, n6);
                System.out.printf(Multilingual.mlnJapanese ? "SRAM \u306b\u3042\u308b ROM \u8d77\u52d5\u30cf\u30f3\u30c9\u30eb\u3092 $%08X \u304b\u3089 $%08X \u306b\u5909\u66f4\u3057\u307e\u3057\u305f\n" : "Changed the ROM boot handle in SRAM from $%08X to $%08X\n", n8, n6);
            }
            int n10 = 15532048;
            int n11 = MainMemory.mmrRls(n10);
            int n12 = smrRAMBootAddress;
            if (n12 != -1 && n11 != n12) {
                MainMemory.mmrWl(n10, n12);
                System.out.printf(Multilingual.mlnJapanese ? "SRAM \u306b\u3042\u308b RAM \u8d77\u52d5\u30a2\u30c9\u30ec\u30b9\u3092 $%08X \u304b\u3089 $%08X \u306b\u5909\u66f4\u3057\u307e\u3057\u305f\n" : "Changed the RAM boot address in SRAM from $%08X to $%08X\n", n11, n12);
            }
            int n13 = 15532056;
            int n14 = MainMemory.mmrRwz(n13);
            int n15 = n5 = XEiJ.mpuBootDevice != -1 ? XEiJ.mpuBootDevice : smrBootDevice;
            if (n5 != -1 && n14 != n5) {
                MainMemory.mmrWw(n13, n5);
                System.out.printf(Multilingual.mlnJapanese ? "SRAM \u306b\u3042\u308b\u8d77\u52d5\u30c7\u30d0\u30a4\u30b9\u3092 %s \u304b\u3089 %s \u306b\u5909\u66f4\u3057\u307e\u3057\u305f\n" : "Changed the boot device in SRAM from %s to %s\n", SRAM.smrBootDescription(n8, n11, n14), SRAM.smrBootDescription(n6, n12, n5));
            }
            int n16 = 15532090;
            int n17 = MainMemory.mmrRbz(n16);
            int n18 = smrRepeatDelay;
            if (n18 != -1 && n17 != n18) {
                MainMemory.mmrWb(n16, n18);
                System.out.printf(Multilingual.mlnJapanese ? "SRAM \u306b\u3042\u308b\u30ea\u30d4\u30fc\u30c8\u958b\u59cb\u3092 %dms \u304b\u3089 %dms \u306b\u5909\u66f4\u3057\u307e\u3057\u305f\n" : "Changed the repeat delay in SRAM from %dms to %dms\n", 200 + 100 * (n17 & 0xF), 200 + 100 * (n18 & 0xF));
            }
            int n19 = 15532091;
            int n20 = MainMemory.mmrRbz(n19);
            int n21 = smrRepeatInterval;
            if (n21 != -1 && n20 != n21) {
                MainMemory.mmrWb(n19, n21);
                System.out.printf(Multilingual.mlnJapanese ? "SRAM \u306b\u3042\u308b\u30ea\u30d4\u30fc\u30c8\u9593\u9694\u3092 %dms \u304b\u3089 %dms \u306b\u5909\u66f4\u3057\u307e\u3057\u305f\n" : "Changed the repeat interval in SRAM from %dms to %dms\n", 30 + 5 * (n17 & 0xF), 30 + 5 * (n18 & 0xF));
            }
            if (smrRomdbFlag != -1) {
                int n22;
                n4 = XEiJ.currentAccelerator == 1 || XEiJ.currentAccelerator == 3 || XEiJ.currentAccelerator == 4 || ROM.romIPLROM16On ? 1 : 0;
                n3 = XEiJ.currentModel.getIPLROM() == 130 && n4 == 0 && ROM.romROM30Data == null ? 1 : 0;
                n2 = 15532120;
                n = MainMemory.mmrRbz(n2);
                int n23 = n3 != 0 ? 0 : (n22 = n4 == 0 && smrRomdbFlag == 1 ? 255 : smrRomdbFlag);
                if (n != n22) {
                    MainMemory.mmrWb(n2, n22);
                    Object[] objectArray = new Object[2];
                    Object object = n == 0 ? "OFF" : (objectArray[0] = n == 255 ? "AUX" : "CON");
                    objectArray[1] = n22 == 0 ? "OFF" : (n22 == 255 ? "AUX" : "CON");
                    System.out.printf(Multilingual.mlnJapanese ? "SRAM \u306b\u3042\u308b ROM \u30c7\u30d0\u30c3\u30ac\u8d77\u52d5\u30d5\u30e9\u30b0\u3092 %s \u304b\u3089 %s \u306b\u5909\u66f4\u3057\u307e\u3057\u305f\n" : "ROM debugger startup flag in SRAM changed from %s to %s\n", objectArray);
                }
            }
            n4 = 15532122;
            n3 = MainMemory.mmrRbz(n4);
            n2 = MainMemory.mmrRbz(15532143) == 86 ? MainMemory.mmrRbz(15532145) : 0;
            int n24 = n = SPC.spcSCSIINOn ? 2 * (32 - Integer.numberOfLeadingZeros(n2)) : HDC.hdcHDMax;
            if (n3 != n) {
                MainMemory.mmrWb(n4, n);
                System.out.printf(Multilingual.mlnJapanese ? "SRAM \u306b\u3042\u308b SASI \u30cf\u30fc\u30c9\u30c7\u30a3\u30b9\u30af\u306e\u6700\u5927\u6570\u3092 %d \u304b\u3089 %d \u306b\u5909\u66f4\u3057\u307e\u3057\u305f\n" : "Changed the maximum number of SASI hard disks in SRAM from %d to %d\n", n3, n);
            }
        }
    }

    public static String smrBootDescription(int n, int n2, int n3) {
        switch (n3 & 0xF000) {
            case 32768: {
                return "HD" + (n3 >> 8 & 0xF);
            }
            case 36864: {
                return "2HD" + (n3 >> 8 & 3);
            }
            case 40960: {
                return (n & 0xFFFFFFE3) == 0xFC0000 ? "SCSI" + (n >> 2 & 7) : ((n & 0xFFFFFFE3) == 15335456 ? "SCSI" + (n >> 2 & 7) : "ROM$" + XEiJ.fmtHex6(n));
            }
            case 45056: {
                return "RAM$" + XEiJ.fmtHex6(n2);
            }
        }
        return "STD";
    }

    public static void smrClear() {
        XEiJ.pnlExitFullScreen(true);
        if (JOptionPane.showConfirmDialog(XEiJ.frmFrame, Multilingual.mlnJapanese ? "SRAM \u3092\u30af\u30ea\u30a2\u3057\u307e\u3059\u304b\uff1f" : "Do you want to clear SRAM?", Multilingual.mlnJapanese ? "\u78ba\u8a8d" : "Confirmation", 0, -1) == 0) {
            Arrays.fill(MainMemory.mmrM8, 0xED0000, 0xEE0000, (byte)0);
        }
    }

    public static void smrLoad() {
        File file;
        String string;
        JFileChooser2 jFileChooser2 = new JFileChooser2();
        jFileChooser2.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                String string = file.getName();
                String string2 = string.toUpperCase();
                return file.isDirectory() || file.isFile() && string2.startsWith("SRAM");
            }

            @Override
            public String getDescription() {
                return Multilingual.mlnJapanese ? "SRAM \u30c7\u30fc\u30bf\u30d5\u30a1\u30a4\u30eb (SRAM*.*)" : "SRAM data files (SRAM*.*)";
            }
        });
        if (jFileChooser2.showOpenDialog(null) == 0 && !SRAM.smrLoadData(string = (file = jFileChooser2.getSelectedFile()).getPath())) {
            XEiJ.pnlExitFullScreen(true);
            JOptionPane.showMessageDialog(null, Multilingual.mlnJapanese ? string + " \u306e\u30b5\u30a4\u30ba\u304c\u9055\u3044\u307e\u3059" : string + " has wrong size");
            return;
        }
    }

    public static boolean smrLoadData(String string) {
        byte[] byArray = XEiJ.rscGetFile(string, smrSramSizeRequest);
        if (byArray != null) {
            System.arraycopy(byArray, 0, MainMemory.mmrM8, 0xED0000, smrSramSizeRequest);
            if (smrSramSizeRequest < 65536) {
                Arrays.fill(MainMemory.mmrM8, 0xED0000 + smrSramSizeRequest, 0xEE0000, (byte)0);
            }
            return true;
        }
        return false;
    }

    public static void smrSave() {
        JFileChooser2 jFileChooser2 = new JFileChooser2();
        jFileChooser2.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                String string = file.getName();
                String string2 = string.toUpperCase();
                return file.isDirectory() || file.isFile() && string2.startsWith("SRAM");
            }

            @Override
            public String getDescription() {
                return Multilingual.mlnJapanese ? "SRAM \u30c7\u30fc\u30bf\u30d5\u30a1\u30a4\u30eb (SRAM*.*)" : "SRAM data files (SRAM*.*)";
            }
        });
        if (jFileChooser2.showSaveDialog(null) == 0) {
            XEiJ.rscPutFile(jFileChooser2.getSelectedFile().getPath(), MainMemory.mmrM8, 0xED0000, smrSramSizeRequest);
        }
    }
}

